/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.log;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.log.LogAttributes;
import com.ibm.hwmca.fw.log.LogBlock;
import com.ibm.hwmca.fw.log.LogBlockFilter;
import com.ibm.hwmca.fw.log.LogEntryId;
import com.ibm.hwmca.fw.log.LogErrorIds;
import com.ibm.hwmca.fw.tasklet.Tasklet;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.tasklet.TaskletRequest;
import com.ibm.hwmca.fw.tasklet.TaskletResponse;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Date;

public class LoggerTasklet
extends Tasklet
implements LogErrorIds {
    private static final boolean MYDEBUG = false;
    private static boolean dllLoaded = false;
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "LoggerTasklet");
    private static final String TRACE_MASKT = "XFRMLGTT";
    private static final String TRACE_MASKF = "XFRMLGTF";
    private static final String TRACE_MASKD = "XFRMLGTD";

    public void init(Object initData) throws TaskletException {
    }

    public void service(TaskletRequest request, TaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> service()");
        if (request.isNormal()) {
            try {
                if (request != null && !request.isInitialRequest()) {
                    String action = (String)request.getData("Action");
                    if (action.equals("log")) {
                        try {
                            Log log = (Log)request.getData("Log");
                            LogAttributes logAttributes = (LogAttributes)request.getData("LogAttributes");
                            LogEntryId logEntryId = this.log(log, logAttributes);
                            response.setData("LogEntryId", logEntryId);
                        }
                        catch (HException exc) {
                            Trace.trace(TRACE_MASKF, "Error creating log entry");
                            Trace.trace(TRACE_MASKF, exc);
                            response.error(new LocalizableText(""), "");
                        }
                    } else if (action.equals("retrieve")) {
                        Byte logClass = (Byte)request.getData("LogClass");
                        Byte logType = (Byte)request.getData("LogType");
                        Short user = (Short)request.getData("User");
                        Date startTime = (Date)request.getData("StartTime");
                        Date endTime = (Date)request.getData("EndTime");
                        LogBlockFilter[] logBlockFilters = (LogBlockFilter[])request.getData("LogBlockFilters");
                        byte[] logBlockIds = (byte[])request.getData("LogBlockIds");
                        String logId = (String)request.getData("LogId");
                        Integer eventCount = (Integer)request.getData("EventCount");
                        Log[] logs = this.retrieve(logClass, logType, user, startTime, endTime, logBlockFilters, logBlockIds, eventCount, logId);
                        response.setData("Logs", logs);
                    } else if (action.equals("multiRetrieve")) {
                        Byte[] logClasses = (Byte[])request.getData("LogClasses");
                        Byte logType = (Byte)request.getData("LogType");
                        Date startTime = (Date)request.getData("StartTime");
                        Date endTime = (Date)request.getData("EndTime");
                        String logId = (String)request.getData("LogId");
                        Log[] logs = this.retrieve(logClasses, logType, startTime, endTime, logId);
                        response.setData("Logs", logs);
                    } else if (action.equals("retrieveSpan")) {
                        Byte logClass = (Byte)request.getData("LogClass");
                        Byte logType = (Byte)request.getData("LogType");
                        Short user = (Short)request.getData("User");
                        Date startTime = (Date)request.getData("StartTime");
                        Date endTime = (Date)request.getData("EndTime");
                        LogBlockFilter[] logBlockFilters = (LogBlockFilter[])request.getData("LogBlockFilters");
                        byte[] logBlockIds = (byte[])request.getData("LogBlockIds");
                        String logId = (String)request.getData("LogId");
                        long offset = (Long)request.getData("Offset");
                        long count = (Long)request.getData("Count");
                        long options = (Long)request.getData("Options");
                        Log[] logs = this.retrieveSpan(logClass, logType, user, startTime, endTime, logBlockFilters, logBlockIds, logId, offset, count, options);
                        response.setData("Logs", logs);
                    } else if (action.equals("multiRetrieveSummary")) {
                        Trace.trace(TRACE_MASKT, "-> multiRetrieveSummary");
                        Byte[] logClasses = (Byte[])request.getData("LogClasses");
                        Byte logType = (Byte)request.getData("LogType");
                        Date startTime = (Date)request.getData("StartTime");
                        Date endTime = (Date)request.getData("EndTime");
                        String logId = (String)request.getData("LogId");
                        Integer forceGet = (Integer)request.getData("ForceGet");
                        Log[] logs = this.retrieveSummary(logClasses, logType, startTime, endTime, logId, forceGet);
                        response.setData("Logs", logs);
                    } else if (action.equals("updateModifyBlock")) {
                        LogEntryId logEntryId = (LogEntryId)request.getData("LogEntryId");
                        byte[] newValue = (byte[])request.getData("NewValue");
                        this.updateModifyBlock(logEntryId, newValue);
                    } else if (action.equals("getTrace")) {
                        Integer bufferId = (Integer)request.getData("BufferId");
                        String buffer = this.getTrace(bufferId);
                        response.setData("Buffer", buffer);
                    } else if (action.equals("getTraces")) {
                        int[] bufferIds = (int[])request.getData("BufferIds");
                        String[] buffers = this.getTraces(bufferIds);
                        response.setData("Buffers", buffers);
                    } else if (action.equals("getLogBlocks")) {
                        Integer jniDataBlocks = (Integer)request.getData("JniDataBlocks");
                        LogBlock[] logBlocks = this.getLogBlocks(jniDataBlocks);
                        response.setData("LogBlocks", logBlocks);
                    } else if (action.equals("incrementRefCount")) {
                        Integer jniDataBlocks = (Integer)request.getData("JniDataBlocks");
                        this.incrementRefCount(jniDataBlocks);
                    } else if (action.equals("free")) {
                        Integer jniDataBlocks = (Integer)request.getData("JniDataBlocks");
                        this.free(jniDataBlocks);
                    } else if (action.equals("getLogHeader")) {
                        String logId = (String)request.getData("LogId");
                        byte[] logHeader = this.getLogHeader(logId);
                        response.setData("LogHeader", logHeader);
                    } else {
                        Trace.trace(TRACE_MASKF, "Unknown action=" + action);
                    }
                }
            }
            catch (HException exc) {
                response.error(new LocalizableText(""), "");
                Trace.trace(TRACE_MASKF, exc);
                throw new TaskletException(exc);
            }
        }
        if (!response.isResponseSet()) {
            response.noAction();
        }
        Trace.trace(TRACE_MASKT, "<- service()");
    }

    public void logException(Throwable thrown) {
        new FrameworkLog(classLogInfo, 18, thrown).log();
    }

    public static void purge(String logId) throws HException {
        if (!dllLoaded) {
            HException exc = new HException("Error loading libjnilog.so");
            exc.setLogged(true);
            throw exc;
        }
        LoggerTasklet.jniPurge(logId);
    }

    private LogEntryId log(Log log, LogAttributes attribs) throws HException {
        LogEntryId result = null;
        if (!dllLoaded) {
            throw new HException("Error loading libjnilog.so");
        }
        result = this.jniLog(log, attribs);
        return result;
    }

    private Log[] retrieveSpan(Byte logClass, Byte logType, Short user, Date startTime, Date endTime, LogBlockFilter[] logBlockFilters, byte[] logBlockIds, String logId, long offset, long count, long options) throws HException {
        Log[] result = null;
        if (!dllLoaded) {
            HException exc = new HException("Error loading libjnilog.so");
            exc.setLogged(true);
            throw exc;
        }
        result = this.jniRetrieveSpan(logClass, logType, user, startTime, endTime, logBlockFilters, logBlockIds, logId, offset, count, options);
        return result;
    }

    private Log[] retrieve(Byte logClass, Byte logType, Short user, Date startTime, Date endTime, LogBlockFilter[] logBlockFilters, byte[] logBlockIds, Integer eventCount, String logId) throws HException {
        Log[] result = null;
        if (!dllLoaded) {
            HException exc = new HException("Error loading libjnilog.so");
            exc.setLogged(true);
            throw exc;
        }
        result = this.jniRetrieve(logClass, logType, user, startTime, endTime, logBlockFilters, logBlockIds, eventCount, logId);
        return result;
    }

    private Log[] retrieve(Byte[] logClasses, Byte logType, Date startTime, Date endTime, String logId) throws HException {
        Log[] result = null;
        if (!dllLoaded) {
            HException exc = new HException("Error loading libjnilog.so");
            exc.setLogged(true);
            throw exc;
        }
        result = this.jniMultiRetrieve(logClasses, logType, startTime, endTime, logId);
        return result;
    }

    private Log[] retrieveSummary(Byte[] logClasses, Byte logType, Date startTime, Date endTime, String logId, Integer forceGet) throws HException {
        Log[] result = null;
        if (!dllLoaded) {
            HException exc = new HException("Error loading libjnilog.so");
            exc.setLogged(true);
            throw exc;
        }
        result = this.jniMultiRetrieveSummary(logClasses, logType, startTime, endTime, logId, forceGet);
        return result;
    }

    private void updateModifyBlock(LogEntryId logEntryId, byte[] newValue) throws HException {
        if (!dllLoaded) {
            HException exc = new HException("Error loading libjnilog.so");
            exc.setLogged(true);
            throw exc;
        }
        this.jniUpdateModifyBlock(logEntryId, newValue);
    }

    private String getTrace(int bufferId) {
        String[] result = new String[]{""};
        int[] bufferIds = new int[]{bufferId};
        if (dllLoaded) {
            result = this.jniGetTraces(bufferIds);
        }
        return result[0];
    }

    private String[] getTraces(int[] bufferIds) {
        String[] result;
        if (dllLoaded) {
            result = this.jniGetTraces(bufferIds);
        } else {
            result = new String[bufferIds.length];
            for (int ix = 0; ix < bufferIds.length; ++ix) {
                result[ix] = "";
            }
        }
        return result;
    }

    private LogBlock[] getLogBlocks(int jniDataBlocks) {
        LogBlock[] result = null;
        if (dllLoaded) {
            result = this.jniGetLogBlocks(jniDataBlocks);
        }
        return result;
    }

    private void incrementRefCount(int jniDataBlocks) {
        if (dllLoaded) {
            this.jniIncrementRefCount(jniDataBlocks);
        }
    }

    private void free(int jniDataBlocks) {
        if (dllLoaded) {
            this.jniFree(jniDataBlocks);
        }
    }

    private byte[] getLogHeader(String logId) throws HException {
        byte[] result = null;
        if (!dllLoaded) {
            HException exc = new HException("Error loading libjnilog.so");
            exc.setLogged(true);
            throw exc;
        }
        result = this.jniGetLogHeader(logId);
        return result;
    }

    private native byte[] jniGetLogHeader(String var1) throws HException;

    private native LogEntryId jniLog(Log var1, LogAttributes var2) throws HException;

    private native Log[] jniRetrieve(Byte var1, Byte var2, Short var3, Date var4, Date var5, LogBlockFilter[] var6, byte[] var7, Integer var8, String var9) throws HException;

    private native Log[] jniMultiRetrieve(Byte[] var1, Byte var2, Date var3, Date var4, String var5) throws HException;

    private native Log[] jniMultiRetrieveSummary(Byte[] var1, Byte var2, Date var3, Date var4, String var5, Integer var6) throws HException;

    private native Log[] jniRetrieveSpan(Byte var1, Byte var2, Short var3, Date var4, Date var5, LogBlockFilter[] var6, byte[] var7, String var8, long var9, long var11, long var13) throws HException;

    private native void jniUpdateModifyBlock(LogEntryId var1, byte[] var2);

    private static native void jniPurge(String var0);

    private native String[] jniGetTraces(int[] var1);

    private native LogBlock[] jniGetLogBlocks(int var1);

    private native void jniFree(int var1);

    private native void jniIncrementRefCount(int var1);

    static {
        try {
            System.loadLibrary("jnilog");
            dllLoaded = true;
        }
        catch (Throwable thrown) {
            Trace.trace(TRACE_MASKF, "Error loading library jnilog");
            Trace.trace(TRACE_MASKF, thrown);
        }
    }
}

